<?php
namespace ISProject\Controllers;

use ISProject\Models\Posts;

class SpecialPageController extends ControllerBase
{

    public function indexAction()
    {

        $slug = $this->dispatcher->getParam('slug');
        if ($slug === null) {
            return $this->response->redirect('/')->send();
        }

        $page = (new Posts())->findPostBySlug($slug);
        if (!isset($page->id)) {
            return $this->response->redirect('/')->send();
        }

        $this->view->page = $page;
        $this->view->title = $page->name;
    }
    
}

