<?php

namespace ISProject\Controllers\Admin;


use ISProject\Helper\JsonPage\JsonPage;
use Phalcon\Mvc\Controller;
use ISProject\Config\Config;
use ISProject\Models\Options;
use ScssPhp\ScssPhp\Compiler;

class ControllerBase extends Controller
{

    /**
     *
     * PageJSON Sınıfını barındırır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @var PageJSON $page
     *
     */
    public $page = null;

    /**
     *
     * Sistem ayar bilgilerini barındırır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @var array $config
     *
     */
	public $config;

    /**
     *
     * Controller çağrılmadan önce gerekli ayarlamaları yapar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
	public function onConstruct()
	{

        $config       = new Config();
        $this->config = $config->configParser( (new Options())->getAllOptions() );
		$this->view->setVars($config->getDefaultConfigTemplateValues());

		$this->setPartialsDir('');
    	$this->setViewsDir('pages');
	    $this->setMainView('master');

        $this->page = new JsonPage();
        $this->auth->deleteErrorSuccess();
	}

    /**
     *
     * Partial klasörünün yolunu değiştirir.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @param string $degisken
     *
     */
    public function setPartialsDir($fileName)
    {
        $this->view->setPartialsDir(Config::getThemeAdminPath() . $fileName);
    }

    /**
     *
     * View klasöründeki çalışacak main dosyasını değiştirir.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @param string $degisken
     *
     */
    public function setMainView($fileName)
    {
        $this->view->setMainView(Config::getThemeAdminPath() . $fileName);
    }

    /**
     *
     * View klasörünün yolunu değiştirir.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @param string $degisken
     *
     */
    public function setViewsDir($fileName)
    {
        $this->view->setViewsDir(Config::getThemeAdminPath() . $fileName);
    }

}