<?php

namespace ISProject\Controllers\Admin;

use ISProject\Helper\FileUpload\FileUpload;
use ISProject\Models\Options;
use ISProject\Helper\Utility\Utility;
use ISProject\Models\Posts;

class SpecialPageController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak oturum açık ise panele yönlendirilir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {

        if (!$this->auth->checkSession()) {
            return $this->response->redirect('admin/login/')->send();
        }

        $this->view->page = $this->page->get('urunler');
    }

    /**
     *
     * Detay sayfasını açar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function detayAction()
    {

        $pageSort = $this->dispatcher->getParam(0);
        if ($pageSort === null) {
            return $this->response->redirect('admin/')->send();
        }

        $pages = (new Posts())->findPostByType('page');
        if (!isset($pages[$pageSort - 1])) {
            return $this->response->redirect('admin/')->send();
        }

        $this->view->page   = $pages[$pageSort - 1];
        $this->view->sortId = $pageSort;
    }

    public function saveAction()
    {

        $pageId  = $this->request->getPost('pageId');
        $sortId  = $this->request->getPost('sortId');
        $name    = $this->request->getPost('name');
        $content = $this->request->getPost('content');
        if ($pageId === null) {
            return $this->response->redirect('admin/')->send();
        }

        $posts   = new Posts();
        $post  = $posts->findPostById($pageId);
        if (!isset($post->id)) {
            return $this->response->redirect('admin/')->send();
        }

        $slugify = (new Utility())->postSlugify($name, $pageId);

        $this->config->general->pages->{"page" . $sortId}->name = $name;
        $this->config->general->pages->{"page" . $sortId}->slug = $slugify;
        
        $options = new Options();
        $options->updateOption('general', json_encode($this->config->general));

        $posts->updatePost($pageId, array('name' => $name, 'slug' => $slugify, 'content' => $content));
        return $this->response->redirect('admin/specialPage/detay/' . $sortId)->send();
    }
}

