<?php

namespace ISProject\Controllers\Admin;

use ISProject\Helper\FileUpload\FileUpload;
use ISProject\Helper\Utility\Utility;
use ISProject\Models\Posts;

class UrunlerController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak oturum açık ise panele yönlendirilir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {

        if (!$this->auth->checkSession()) {
            return $this->response->redirect('admin/login/')->send();
        }

        if (!$this->page->check('urunler')) {
            return $this->response->redirect('admin/')->send();
        }

        $this->view->page = $this->page->get('urunler');
    }

    /**
     *
     * Ürünler genel bakış görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {
        $this->view->posts = (new Posts())->findPostByType('product');        
    }

    /**
     *
     * Detay sayfasını açar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function detayAction()
    {

        $postId = $this->dispatcher->getParam(0);
        if ($postId === null) {
            return $this->response->redirect('admin/urunler/')->send();
        }

        $post = (new Posts())->findPostById($postId);
        if (!isset($post->id)) {
            return $this->response->redirect('admin/urunler/')->send();
        }

        $post->image = (new Utility())->getPostImage($post->image);
        $this->view->post = $post;
    }

    /**
     *
     * Detay sayfasını açar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function addAction()
    {
        $this->view->pick('urunler/detay');
    }

    /**
     *
     * Kaydet işlemini yapar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function saveAction()
    {
        
        $postId  = $this->request->getPost('productId');
        $name    = $this->request->getPost('name');
        $content = $this->request->getPost('content');
        $image   = $this->request->getPost('image');
        if ($name === null) {
            return $this->response->redirect('admin/urunler/')->send();
        }

        $utility = new Utility();
        $posts   = new Posts();
        if ($postId > 0) {
            $post  = $posts->findPostById($postId);
            if (!isset($post->id)) {
                return $this->response->redirect('admin/urunler/')->send();
            }

            $posts->updatePost($postId, array('name' => $name, 'slug' => $utility->postSlugify($name, $postId), 'content' => $content));
        } else {
            $postId = $posts->addPost($name, $utility->postSlugify($name), '', $content, time(), 'product');
        }

        $fileupload = new FileUpload();
        $fileupload->setImageResize(array(
            'large'  => array('width' => 600, 'height' => 400),
            'medium' => array('width' => 350, 'height' => 250),
            'small'  => array('width' => 250, 'height' => 250)
        ));

        if ($fileupload->checkFile('image')) 
        {
            $response = $fileupload->uploadImage('image');
            if (!$response['error']) {
                $posts->updatePost($postId, array('image' => json_encode($response['data'])));
            }

            if (isset($post->image)) {
                $fileupload->deleteImage(json_decode($post->image));
            }
        }

        return $this->response->redirect('admin/urunler/detay/' . $postId)->send();
    }

    /**
     *
     * silme işlemini yapar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function deleteAction()
    {
        
        $productId = $this->dispatcher->getParam(0);
        if ($productId === null) {
            return $this->response->redirect('admin/urunler/')->send();
        }

        $posts = new Posts();
        $post  = $posts->findPostById($productId);
        if (!isset($post->id)) {
            return $this->response->redirect('admin/urunler/')->send();
        }

        $posts->deletePost($productId);

        $fileupload = new FileUpload();
        $fileupload->deleteImage(json_decode($post->image));

        return $this->response->redirect('admin/urunler/detay/' . $productId)->send();
    }

    /**
     *
     * Ürünler Alananının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function urunlerAction()
    {

        $urunId = $this->request->getPost('urunler');
        if ($urunId === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('add') !== null) 
        {
            $this->page->addData('urunler', 'urunler', array(
                'title'       => '', 
                'description' => '',
                'active'      => true,
                'image'       => array(
                    'large'  => array('width' => 600, 'height' => 400),
                    'medium' => array('width' => 350, 'height' => 250)
                )
            ));
            $this->auth->successAdd('Ürün başarıyla eklendi.');
        }
        else if ($this->request->getPost('update') !== null) 
        {
            $response = $this->page->update('urunler', 'urunler', array(
                    'dataId'      => $urunId,
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'description' => mb_substr($this->request->getPost('description', 'trim'), 0, CMS_MEDIUM_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                    'image'       => array(
                        'large'  => array('width' => 600, 'height' => 400),
                        'medium' => array('width' => 350, 'height' => 250),
                        'small'  => array('width' => 250, 'height' => 250)
                    )
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('Ürün başarıyla güncellendi.');
            }            
        }
        else if($this->request->getPost('delete') !== null)
        {
            $this->page->delete('urunler', 'urunler', $urunId);
            $this->auth->successAdd('Ürün başarıyla silindi.');
        }

        return $this->response->redirect('admin/urunler/')->send();
    }

}

