<?php
namespace ISProject\Auth;

use ISProject\Models\Clients;
use Phalcon\Mvc\User\Component;

class Auth extends Component
{

	/**
	 *
	 * Kullanıcının Bilgilerini içerir
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param object
	 *
	 */
	public $client;

	/**
	 *
	 * Hata mesajlarını oturum üzerinde saklar.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param array
	 *
	 */
	public $errors;

	/**
	 *
	 * Başarılı işlem mesajlarını
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param array 
	 *
	 */
	public $success;

	/**
	 *
	 * Şifrelenmiş oturum kodu
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param string 
	 *
	 */
	private $cyrptAuthPathSession;

	/**
	 *
	 * Oturum ayarlarının yapılması
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 *
	 */
	public function __construct()
	{

		$this->client  = $this->defaultAuth();
		$this->success = $this->getSession( 'success' );
		$this->errors  = $this->getSession( 'errors' );

		$this->checkSession();

	}

	/**
	 *
	 * Giriş işlemini yapar.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param string $email
	 * @param string $password
	 * @return array 
	 *
	 */
	public function userLogin($email, $password)
	{

		$client = (new Clients())->findAdminOfEmail( $email );
		if (!isset($client->id)) {
			return array('error' => true, 'code' => 'email');
		}

		if ($client->password !== $this->uniqueLoginPassword( $password )) {
			return array('error' => true, 'code' => 'password');
		}

		$this->client = $client;
        $this->session->set($this->hashPathSession(), array(
			'id'   => $client->id,
			'hash' => $this->uniqueLoginHash($client->email, $client->password),
        ));

		return array('error' => false);

	}

	/**
	 *
	 * Kullanıcının varlığını veritabanından sorgular ve hash ile doğrulama yapar.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param int $sessionUserID
	 * @param string $sessionUserHash
	 * @return bool 
	 *
	 */
	private function checkUserSession($sessionUserID, $sessionUserHash)
	{

		$client = (new Clients())->findUsersOfID($sessionUserID);
		if(!isset($client->id)){
			$this->closeSession();
			return false;
		}

		if($this->uniqueLoginHash($client->email, $client->password) !== $sessionUserHash){
			$this->closeSession();
			return false;
		}

		$this->client = $client;
		return true;

	}

	/**
	 *
	 * Oturumun aktifliğini kontrol etme
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @return bool 
	 *
	 */
	public function checkSession( )
	{
		$sessionUserInformation = $this->sessionUserInformation();
		if($sessionUserInformation["hash"] !== null && $sessionUserInformation["id"] !== null)
		{

			if( $this->client->id > 0 ){
				return true;
			}

			return $this->checkUserSession( $sessionUserInformation["id"] , $sessionUserInformation["hash"] );
		}
		 
		return false;	 
	}	

	/**
	 *
	 * Verilen şifreyi belirli algoritmalar ile şifreler.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param string $password
	 * @return string 
	 *
	 */
	public function uniqueLoginPassword($password )
	{
		return md5('lambda' . sha1(md5(md5($password))) . '27.04.1999');
	}

	/**
	 *
	 * Benzersiz giriş güvenlik kodunu döndürür.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param string $email 
	 * @param string $password 
	 * @return string 
	 *
	 */
	private function uniqueLoginHash($email , $password )
	{
		return md5('login_hash' . sha1($email . $password) . $password . '27.04.1999');
	}

	/**
	 *
	 * Oturumun şifrelenmiş verisini döndürür.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @return string 
	 *
	 */
	private function hashPathSession()
	{
		if( $this->cyrptAuthPathSession !== null ){
			return $this->cyrptAuthPathSession;
		}

		return $this->cyrptAuthPathSession = md5(APP_PATH .  "uye_hash");
	}

	/**
	 *
	 * Standart Oturum Verisi
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @return string 
	 *
	 */
	protected function defaultAuth()
	{

		return (Object)array("id" => 0);
	}

	/**
	 *
	 * İstenilen Oturum verisini döndürür 
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param string $key
	 * @return array|string 
	 *
	 */
	protected function getSession($key)
	{

		$value = $this->session->get($key);
		if ($value !== null) {
			return $value;
		}

		return array();
	}

	/**
	 *
	 * Oturum Kodunu ve ID'sini verir.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @return array 
	 *
	 */
	protected function sessionUserInformation()
	{

		$auth = $this->session->get($this->hashPathSession());
		return array(
			'hash' => isset( $auth["hash"] ) ? $auth["hash"] : null,
			'id'   => isset( $auth["id"] ) ? $auth["id"] : null,
		);

	}

	/**
	 *
	 * Başarılı mesajları oturuma kaydeder.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param string $message 
	 * @param string $key
	 *
	 */
	public function successAdd($message)
	{
		$this->session->set('success', $this->success = $message);
	}

	/**
	 *
	 * Hataları mesajları oturuma kaydeder.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 * @param string $message 
	 * @param string $key
	 *
	 */
	public function errorAdd($message)
	{
		$this->session->set('errors', $this->errors = $message);
	}	

	/**
	 *
	 * Hata ve başarılı mesajları oturumdan siler.
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 *
	 */
	public function deleteErrorSuccess()
	{

		$this->session->remove('errors');
		$this->session->remove('success');

	}

	/**
	 *
	 * Mevcut kullanıcı Oturumunu Kapatma
	 *
	 * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
	 *
	 */
	public function closeSession()
	{
		
		$this->client = $this->defaultAuth();	 
		$this->session->remove( $this->hashPathSession() );

	}	

}