<?php 

namespace ISProject\Helper\JsonPage;

Class JsonFormatter
{

	/**
	 *
	 * Verileri depolar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @var array $pages
	 *
	 */
	protected $data = array();
	/**
	 *
	 * Özel verileri depolar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @var array $pages
	 *
	 */
	protected $specialData = array();

	/**
	 *
	 * Section'u depolar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @var string $pages
	 *
	 */
	protected $section = '';

	/**
	 *
	 * Verileri günceller.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return array
	 *
	 */
	public function getDatas()
	{
		return $this->data;
	}

	/**
	 *
	 * Verileri günceller.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param array $data
	 *
	 */
	public function setData($data)
	{
		$this->data = $data;
		$this->initializeClear();
	}

	/**
	 *
	 * Bölümü günceller.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $section
	 *
	 */
	public function setSection($section)
	{
		$this->section = $section;
	}

	/**
	 *
	 * Data Id değerini döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return int 
	 *
	 */
	public function getDataId()
	{
		return $this->checkDataId() ? $this->specialData['dataId'] : null;
	}

	/**
	 *
	 * İçeriğin silinip silinmeyeceğini döner.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return boolean 
	 *
	 */
	public function checkDelete()
	{
		return isset($this->specialData['delete']) && $this->specialData['delete'];
	}

	/**
	 *
	 * Image değerini günceller
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param array $data 
	 *
	 */
	public function setImageData($data)
	{
		$this->data['image'] = $data;
	}

	/**
	 *
	 * deleteImage değerini günceller
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param boolean $data 
	 *
	 */
	public function setImageDelete($type)
	{
		$this->specialData['deleteImage'] = $type === true;
	}

	/**
	 *
	 * deleteDataImage değerini günceller
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param boolean $data 
	 *
	 */
	public function setImageDataDelete($type)
	{
		$this->specialData['deleteDataImage'] = $type === true;
	}

	/**
	 *
	 * errorMessage varlığını kontrol eder.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return boolean
	 *
	 */
	public function isError()
	{
		return isset($this->specialData['errorMessage']);
	}

	/**
	 *
	 * errorMessage değerini günceller
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param $message
	 *
	 */
	public function setErrorMessage($message)
	{
		$this->specialData['errorMessage'] = $message;
	}

	/**
	 *
	 * errorMessage değerini döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return string
	 *
	 */
	public function getErrorMessage()
	{
		return $this->specialData['errorMessage'];
	}

	/**
	 *
	 * deleteDataImage değerini döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return boolean $data 
	 *
	 */
	public function checkImageDataDelete()
	{
		return isset($this->specialData['deleteDataImage']) && $this->specialData['deleteDataImage'];
	}

	/**
	 *
	 * deleteImage değerini döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return boolean $data 
	 *
	 */
	public function checkImageDelete()
	{
		return isset($this->specialData['deleteImage']) && $this->specialData['deleteImage'];
	}

	/**
	 *
	 * deleteThumbnail değerini döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return boolean $data 
	 *
	 */
	public function checkThumbnailDelete()
	{
		return isset($this->specialData['deleteThumbnail']) && $this->specialData['deleteThumbnail'];
	}

	/**
	 *
	 * Image değerini döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return boolean 
	 *
	 */
	public function checkImage()
	{
		return isset($this->specialData['image']);
	}

	/**
	 *
	 * Image değerini döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return boolean 
	 *
	 */
	public function checkEmptyCreateImage($pageData)
	{
		return $this->checkImage() && !isset($pageData['image']);
	}

	/**
	 *
	 * Image değerini döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return array 
	 *
	 */
	public function getImage()
	{
		return $this->specialData['image'];
	}

	/**
	 *
	 * Data Id varlığını kontrol eder.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return boolean 
	 *
	 */
	public function checkDataId()
	{
		return isset($this->specialData['dataId']);
	}

	/**
	 *
	 * Section varlığını kontrol eder.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return boolean 
	 *
	 */
	public function checkSection()
	{
		return !empty($this->section);
	}

	/**
	 *
	 * Section değerini döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return string 
	 *
	 */
	public function getSection()
	{
		return $this->section;
	}

	/**
	 *
	 * Dizideki Son Id değerini +1 olarak döner
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param array $datas
	 * @return int 
	 *
	 */
	public function getLastDataId($datas)
	{
		$counter = 0;
		while (true) 
		{
			if (!isset($datas[$counter++])) {
				return --$counter;
			}
		}
	}

	/**
	 *
	 * Özel verileri siler ve depolar
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 *
	 */
	public function initializeClear()
	{
		$this->specialData = array();
		if (isset($this->data['dataId'])) {
			$this->specialData['dataId'] = $this->data['dataId'];
		}

		if (isset($this->data['image'])) {
			$this->specialData['image'] = $this->data['image'];
		}

		if (isset($this->data['add'])) {
			$this->specialData['add'] = $this->data['add'];
		}

		if (isset($this->data['delete'])) {
			$this->specialData['delete'] = $this->data['delete'];
		}

		if (isset($this->data['deleteImage']) || $this->checkDelete()) {
			$this->specialData['deleteImage'] = $this->specialData['deleteDataImage'] = isset($this->data['deleteImage']) ? $this->data['deleteImage'] : true;
		}

		if (isset($this->data['deleteThumbnail'])) {
			$this->specialData['deleteThumbnail'] = isset($this->data['deleteThumbnail']) ? $this->data['deleteThumbnail'] : true;
		}

		unset($this->data['dataId'], $this->data['image'], $this->data['deleteImage'], $this->data['delete'], $this->data['add'], $this->data['deleteThumbnail']);
	}

}