<?php

namespace ISProject\Helper\Pagination;

Class Pagination
{

	private $limit = 10;

	public function setPaginationLimit($limit)
	{
		$limit = intval($limit);
		if ($limit < 1) {
			$limit = 10;
		}

		$this->limit = $limit;
	}

	public function sayfaLimit($page, $max = -1)
	{
		$page = intval($page) - 1;
		if($page < 1){
			$page = 0;
		}

		if( $max < 1 ){
			$max = $this->limit;
		}

		return  array(
			"string" => ($page * $max) . ',' . $max,
			"now"    => $page,
			"page1"  => $page * $max,
			"page2"  => $max,
		);
	}

	public function getMaxPagination($datacount)
	{
		return ceil($datacount / $this->limit);
	}
	
}