<?php 

namespace ISProject\Helper\Utility;

use ISProject\Config\Config;
use ISProject\Models\Posts;

Class Utility
{

	/**
	 *
	 * Public klasörünün yolunu döndürür.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return string 
	 *
	 */
	public function getPublicFolder($public = true)
	{
		return BASE_PATH . ($public ? '/public/' : '');
	}

	/**
	 *
	 * Public Url yolunu döndürür.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return string 
	 *
	 */
	public function getPublicUrl()
	{
		return Config::getConfig()->site_url . 'public/';
	}

	/**
	 *
	 * Resim yolunu döndürür.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $middlePath
	 * @param string $imagePath
	 * @return string 
	 *
	 */
	public function getImagePath($middlePath, $imagePath, $public = true)
	{
		if (empty($imagePath)) {
			return false;
		}

		return $this->getPublicFolder($public) . $middlePath . $imagePath;
	}

	/**
	 *
	 * Admin Resim linkini döndürür.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $middlePath
	 * @param string $imagePath
	 * @return string 
	 *
	 */
	public function getAdminImageUrl($middlePath, $imagePath)
	{

		if (!empty($imagePath) && file_exists($this->getImagePath(Config::getAssetsAdminPath() . $middlePath, $imagePath, false))) {
			return Config::getThemeAdminUrl() . $middlePath . $imagePath;
		}

		return Config::getThemeAdminUrl() . 'img/noimage.svg';
	}

	/**
	 *
	 * Resim linkini döndürür.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $middlePath
	 * @param string $imagePath
	 * @return string 
	 *
	 */
	public function getImageUrl($middlePath, $imagePath)
	{

		if (!empty($imagePath) && file_exists($this->getImagePath($middlePath, $imagePath))) {
			return $this->getPublicUrl() . $middlePath . $imagePath;
		}
		return false;
		//return Config::getThemeAdminUrl() . 'img/noimage.svg';
	}

	/**
	 *
	 * Resim linkini döndürür.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $middlePath
	 * @param string $imagePath
	 * @return string 
	 *
	 */
	public function getThemeImageUrl($middlePath, $imagePath)
	{

		if (!empty($imagePath) && file_exists($this->getImagePath(Config::getAssetsFrontPath() . $middlePath, $imagePath, false))) {
			return $this->getPublicUrl() . Config::getAssetsFrontPath(false, false) . $middlePath . $imagePath;
		}

		return false;
		//return Config::getThemeAdminUrl() . 'img/noimage.svg';
	}

	/**
	 *
	 * \n karakterini p etiketi olarak dönüştürür.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $data
	 * @return string 
	 *
	 */
	public function nl2P($data)
	{

		$data = htmlspecialchars($data);
		$data = '<p>' . str_replace("\n", '</p><p>', $data) . '</p>';
		return preg_replace('@<p>\s*</p>@', '', $data);
	}

	/**
	 *
	 * Başlığı slug işlemi uygular ve döner.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $name
	 * @return string 
	 *
	 */
	public function postSlugify($name, $postId = 0)
	{

		$slugify = $this->slugify($name);
		$postSlugs = (new Posts())->getPostSlugs($slugify);
		if(isset($postSlugs[$postId])){
			unset($postSlugs[$postId]);
		}

		if (count($postSlugs) > 0 && in_array($slugify, $postSlugs)) {
			$max = 0;

			while(in_array(($slugify . '-' . ++$max ), $postSlugs));

			$slugify .= '-' . $max;
		}

		return $slugify;

	}
	/**
	 *
	 * Başlığı slug işlemi uygular ve döner.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $name
	 * @return string 
	 *
	 */
	public function slugify($name)
	{
    	$options = [
			'separator' => '-',
			'lowercase' => true,
			'regexp'    => '/([^A-Za-z0-9]|-)+/',
    		'rules' => [
    		    "Ç" => "C",
			    "Ğ" => "G",
			    "İ" => "I",
			    "Ş" => "S",
			    "Ö" => "O",
			    "Ü" => "U",
			    "ç" => "c",
			    "ğ" => "g",
			    "ı" => "i",
			    "ş" => "s",
			    "ö" => "o",
			    "ü" => "u"
			]
    	];

        $name = strtr($name, $options["rules"]);

        if ($options['lowercase']) {
            $name = mb_strtolower($name);
        }

        $name = preg_replace($options['regexp'], $options['separator'], $name);

        return trim($name, $options['separator']);
	}

	/**
	 *
	 * Yazıların serilize edilmiş resim formatını döner.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $degisken
	 * @return string 
	 *
	 */
	public function getPostImage($imageData, $type = 'small')
	{

		$responseData = new \StdClass();
		$responseData->url    = "";
		$responseData->exists = false;

		$image = json_decode($imageData);
		if ($image == null) {
			return $responseData;
		}

        $responseData->url    = $this->getImageUrl($image->path, $image->images->{$type});
        $responseData->exists = true;
        return $responseData;
	}
	
}