<?php 
namespace ISProject\Models;


Class Options extends \Phalcon\Mvc\Model
{

	private $db;

	private $prefix;

	public function onConstruct()
	{

		$this->db     = $this->di->getShared('db');
		$this->prefix = $this->getDI()->get('config')->database->prefix;
		
	}

	/**
	 *
	 * Options tablosundaki verileri çeker
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return array 
	 *
	 */
	public function getAllOptions()
	{
		return array_column($this->db->fetchAll("SELECT * FROM {$this->prefix}options WHERE option_auto = :auto", \Phalcon\Db::FETCH_OBJ, array("auto" => 1)), NULL, 'option_name');
	}

	/**
	 *
	 * Option arar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $optionName
	 * @return array 
	 *
	 */
	public function findOptions($optionName)
	{
		return $this->db->fetchOne("SELECT * FROM {$this->prefix}options WHERE option_name = :name" , \Phalcon\Db::FETCH_OBJ , array("name" => $optionName));
	}

	/**
	 *
	 * Option verisini günceller.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $optionName
	 * @param string $data
	 * @return boolean 
	 *
	 */
	public function updateOption($optionName, $data)
	{
		return $this->db->execute("UPDATE {$this->prefix}options SET option_value = ? WHERE option_name = ?" , array($data, $optionName));
	}

}
