<?php 
namespace ISProject\Models;

Class Pages extends \Phalcon\Mvc\Model
{

	private $db;

	private $prefix;

	public function onConstruct()
	{
		$this->db     = $this->di->getShared('db');
		$this->prefix = $this->getDI()->get('config')->database->prefix;
	}

	/**
	 *
	 * Sayfa araması yapar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $pageName
	 * @return array 
	 *
	 */
	public function findPage($pageName)
	{
		return $this->db->fetchOne( "SELECT * FROM {$this->prefix}pages WHERE pageName = :name" , \Phalcon\Db::FETCH_OBJ , array("name" => $pageName) );
	}

	/**
	 *
	 * Sayfa güncellemesi yapar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $pageName
	 * @param string $pageData
	 * @return boolean 
	 *
	 */
	public function updatePage($pageName, $pageData)
	{
		return $this->db->execute("UPDATE {$this->prefix}pages SET pageData = ? WHERE pageName = ?" , array($pageData, $pageName));
	}

}
