<?php 
namespace ISProject\Models;

Class Posts extends \Phalcon\Mvc\Model
{

	private $db;

	private $prefix;

	public function onConstruct()
	{
		$this->db     = $this->di->getShared('db');
		$this->prefix = $this->getDI()->get('config')->database->prefix;
	}

	/**
	 *
	 * Bütün yazıları getirir.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return array 
	 *
	 */
	public function findPostByType($type)
	{
		return $this->db->fetchAll("SELECT * FROM {$this->prefix}posts WHERE type = ? ORDER BY id DESC" , \Phalcon\Db::FETCH_OBJ, array($type));
	}

	/**
	 *
	 * Yazı getirir.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param int $postId
	 * @return array 
	 *
	 */
	public function findPostById($postId)
	{
		return $this->db->fetchOne("SELECT * FROM {$this->prefix}posts WHERE id = ? ORDER BY id DESC", \Phalcon\Db::FETCH_OBJ, array($postId));
	}

	/**
	 *
	 * Yazı getirir.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $slug
	 * @return array 
	 *
	 */
	public function findPostBySlug($slug)
	{
		return $this->db->fetchOne("SELECT * FROM {$this->prefix}posts WHERE slug = ?", \Phalcon\Db::FETCH_OBJ, array($slug));
	}

	/**
	 *
	 * Yazı siler.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param int $postId
	 * @return array 
	 *
	 */
	public function deletePost($postId)
	{
		return $this->db->execute("DELETE FROM {$this->prefix}posts WHERE id = ?", array($postId));
	}

	/**
	 *
	 * Yeni Yazı Eklenir
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $degisken
	 * @return string 
	 *
	 */
	public function addPost($name, $slug, $image, $content, $createdate, $type)
	{
		$this->db->execute("INSERT INTO {$this->prefix}posts (name, slug, image, content, createdate, type) VALUES(?, ?, ?, ?, ?, ?)" , array($name, $slug, $image, $content, $createdate, $type));
		return $this->db->lastInsertId();
	}


	/**
	 *
	 * Güncelleme işlemini yapar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param int $postId
	 * @param array $data
	 * @return boolean 
	 *
	 */
	public function updatePost($postId, $data = array())
	{

		$values = $query = array();

		if (isset($data["name"])) {
			array_push($query , "name = ?");
			array_push($values , $data["name"]);
		}

		if (isset($data["slug"])) {
			array_push($query , "slug = ?");
			array_push($values , $data["slug"]);
		}

		if (isset($data["image"])) {
			array_push($query , "image = ?");
			array_push($values , $data["image"]);
		}

		if (isset($data["content"])) {
			array_push($query , "content = ?");
			array_push($values , $data["content"]);
		}

		if (count($values) <= 0) {
			return false;
		}

		array_push($values , $postId);
		return $this->db->execute("UPDATE {$this->prefix}posts SET " . implode(' , ' , $query) . " WHERE id = ?" , $values);
	}

	/**
	 *
	 * 
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $degisken
	 * @return string 
	 *
	 */
	public function getPostSlugs($name)
	{
		return array_column($this->db->fetchAll("SELECT id, slug FROM {$this->prefix}posts WHERE slug LIKE ? ORDER BY id DESC" , \Phalcon\Db::FETCH_OBJ, array($name . '%')), 'slug' , 'id');
	}

}
