<div class="col-md-12">
	<form method="POST" action="{{ site.admin.url }}ayarlar/colorUpdate">
		<div class="card rounded-0">
			<div class="card-header">
				<button type="submit" name="save" class="btn btn-success float-right btn-sm rounded-0 pl-5 pr-5 mb-md-0 mb-3">Kaydet</button>
				<h4 class="card-title mb-0">Tema Rengi</h4>
			</div>
			<div class="card-body">
				{% set myColors = {'#55acee', '#0084ff', '#0077B5', '#007ee5', '#34465d', '#410093', '#bd081c', '#eb4924', '#b92b27', '#ff6600', '#25D366', '#e4405f'} %}
				<div class="row">
					{% for index, color in myColors %}
						<div class="col-lg-1 col-md-3 col-sm-3 col-3">
						  	<label class="imagecheck mb-3 w-100" onclick="document.getElementById('themeColor').value = '{{ color }}';">
							    <input name="imagecheck" type="radio" value="{{ index }}" {% if site.general.theme.color == color %}checked{% endif %} class="imagecheck-input">
							    <figure class="imagecheck-figure rounded-0" style="background-color: {{ color }};">
							     	<div class="color-box"></div>
							    </figure>
						  	</label>
						</div>
					{% endfor %}
				</div>

				<div class="row">
					<div class="col-md-3 col-12">
						<div class="form-group mb-0">
						 	<label class="form-label font-weight-bold">Özel Renk Kodu <small>(#E67E22)</small></label>
							<input class="form-control rounded-0" placeholder="" maxlength="{{ site.charachter.min }}" id="themeColor" name="themeColor" value="{{ site.general.theme.color|escape }}">
						</div>	
					</div>
				</div>
			</div>
		</div>
	</form>
</div>


<div class="col-md-6">
	<div class="row">
		<div class="col-md-12">
			<form method="POST" action="{{ site.admin.url }}ayarlar/logoUpdate" enctype="multipart/form-data">
				<div class="card mt-5 rounded-0">
					<div class="card-header">
						<button type="submit" name="save" class="btn btn-success float-right btn-sm rounded-0 pl-5 pr-5 mb-md-0 mb-3">Kaydet</button>
						<h4 class="card-title mb-0">Logo</h4>
					</div>
					<div class="card-body">
						{% if site.logo.exists %}
							<img src="{{ site.logo.url }}" class="img-fluid mb-3 border p-3">
						{% else %}
							<img src="{{ site.admin.theme.url }}img/nologo.svg" class="img-fluid mb-3 border p-3">
						{% endif %}
						
						<p class="small">250x68 pixel boyutunda logo yükleyin.</p>

						<div class="input-group">
							<div class="custom-file">
								<input type="file" class="custom-file-input" name="image" id="logoInput">
								<label class="custom-file-label rounded-0 small" for="logoInput">Dosya Seç</label>
							</div>
						</div>
					</div>
				</div>
			</form>
		</div>

		<div class="col-md-12">
			<form method="POST" action="{{ site.admin.url }}ayarlar/kurumsalUpdate" enctype="multipart/form-data">
				<div class="card mt-5 rounded-0">
					<div class="card-header">
						<button type="submit" name="save" class="btn btn-success float-right btn-sm rounded-0 pl-5 pr-5 mb-md-0 mb-3">Kaydet</button>
						<h4 class="card-title mb-0">Footer Metin</h4>
					</div>
					<div class="card-body">
						<div class="row">
							<div class="col-md-12">
								<textarea class="form-control rounded-0" name="kurumsal" rows="4" maxlength="{{ site.charachter.medium }}">{{ site.general.company.kurumsal|escape }}</textarea>
							</div>
						</div>
					</div>
				</div>
			</form>
		</div>

		<div class="col-md-12">
			<form method="POST" action="{{ site.admin.url }}ayarlar/smtpUpdate">
				<div class="card mt-5 rounded-0">
					<div class="card-header">
						<button type="submit" name="save" class="btn btn-success float-right btn-sm rounded-0 pl-5 pr-5 mb-md-0 mb-3">Kaydet</button>
						<h4 class="card-title mb-0">SMTP Ayarları</h4>
					</div>
					<div class="card-body">
						<div class="row">
							<div class="col-md-12 mb-4">
								<label class="form-label font-weight-bold">Posta Sunucusu</label>
								<input type="text" class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="server" value="{{ smtp.server|escape }}">
							</div>
							<div class="col-md-12 mb-4">
								<label class="form-label font-weight-bold">E-Posta Adresi</label>
								<input type="text" class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="username" value="{{ smtp.username|escape }}">
							</div>
							<div class="col-md-12 mb-4">
								<label class="form-label font-weight-bold">E-Posta Şifre</label>
								<input type="text" class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="password" value="{{ smtp.password|escape }}">
							</div>
							<div class="col-md-6 mb-4">
								<label class="form-label font-weight-bold">Port</label>
								<input type="number" class="form-control rounded-0" name="port" value="{{ smtp.port|escape }}">
							</div>
							<div class="col-md-6 mb-4">
								<label class="form-label font-weight-bold">Zaman Aşımı (saniye)</label>
								<input type="number" class="form-control rounded-0" max="30" min="1" name="timeout" value="{{ smtp.timeout|escape }}">
							</div>
							<div class="col-md-12">
								<label class="form-label font-weight-bold w-100">Güvenlik</label>
								<div class="custom-control custom-radio custom-control-inline">
								  	<input type="radio" value="ssl" id="smtpAktif" name="security" {% if smtp.security == 'ssl' %}checked{% endif %} class="custom-control-input">
								  	<label class="custom-control-label" for="smtpAktif">SSL</label>
								</div>
								<div class="custom-control custom-radio custom-control-inline">
								  	<input type="radio" value="tls" id="smtpPasif" name="security" {% if smtp.security == 'tls' %}checked{% endif %} class="custom-control-input">
								  	<label class="custom-control-label" for="smtpPasif">TLS</label>
								</div>										
							</div>
						</div>
					</div>
				</div>
			</form>
		</div>

	</div>
</div>

<div class="col-md-6">
	<div class="row">

		<div class="col-md-12">
			<form method="POST" action="{{ site.admin.url }}ayarlar/pageUpdate">
				<div class="card mt-5 rounded-0">
					<div class="card-header">
						<button type="submit" name="save" class="btn btn-success float-right btn-sm rounded-0 pl-5 pr-5 mb-md-0 mb-3">Kaydet</button>
						<h4 class="card-title mb-0">Menü</h4>
					</div>
					<div class="card-body">
						<ul class="list-group list-group-flush">
							{% for index, page in site.general.pages %}
								<li class="list-group-item d-flex justify-content-between align-items-center rounded-0">
									{{ page.name|escape }}
									<span class="badge">
										<div class="custom-control custom-switch">
										  <input type="checkbox" name="{{ index }}" class="custom-control-input" {% if page.active %}checked{% endif %} id="switch{{ index }}">
										  <label class="custom-control-label" for="switch{{ index }}"></label>
										</div>
									</span>
								</li>
							{% endfor %}
						</ul>
					</div>
				</div>
			</form>
		</div>

		<div class="col-md-12">
			<form method="POST" action="{{ site.admin.url }}ayarlar/seoUpdate">
				<div class="card mt-5 rounded-0">
					<div class="card-header">
						<button type="submit" name="save" class="btn btn-success float-right btn-sm rounded-0 pl-5 pr-5 mb-md-0 mb-3">Kaydet</button>
						<h4 class="card-title mb-0">SEO Açıklama</h4>
					</div>
					<div class="card-body">
						<div class="row">
							<div class="col-md-12">
								<textarea class="form-control rounded-0" name="seoDescription" rows="3" maxlength="{{ site.charachter.min }}">{{ site.general.seo.description|escape }}</textarea>
							</div>	
						</div>
					</div>
				</div>
			</form>
		</div>

		<div class="col-md-12">
			<form method="POST" action="{{ site.admin.url }}ayarlar/passwordUpdate">
				<div class="card mt-5 rounded-0">
					<div class="card-header">
						<button type="submit" name="save" class="btn btn-success float-right btn-sm rounded-0 pl-5 pr-5 mb-md-0 mb-3">Kaydet</button>
						<h4 class="card-title mb-0">Şifre Değiştirme</h4>
					</div>
					<div class="card-body">
						<div class="row">
							<div class="col-md-12 mb-4">
								<label class="form-label font-weight-bold">Eski Şifreniz</label>
								<input type="password" class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="oldPassword">
							</div>
							<div class="col-md-12 mb-4">
								<label class="form-label font-weight-bold">Yeni şifreniz</label>
								<input type="password" class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="newPassword">
							</div>
							<div class="col-md-12 mb-4">
								<label class="form-label font-weight-bold">Yeni şifreniz (Tekrar)</label>
								<input type="password" class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="newPasswordRepeat">
							</div>
						</div>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>

