{{ partial('helpers/onecikangorsel') }}

<div class="col-md-12">
	<div class="card mt-5 rounded-0">

	  	<div class="card-header">
	  		<form method="POST" action="{{ site.admin.url }}hizmetler/hizmetler">
		    	<input type="hidden" name="hizmet" value="1">
		  		<button type="submit" name="add" class="btn btn-primary float-right btn-sm rounded-0 pl-5 pr-5 mb-md-0 mb-3">Yeni Ekle</button>
	  		</form>
	    	<h4 class="card-title mb-0">Hizmetler Alanı</h4>
	  	</div>

	  	<div class="card-body">

			{% for hizmetId, hizmet in page.hizmetler %}
			    <form method="POST" action="{{ site.admin.url }}hizmetler/hizmetler" enctype="multipart/form-data">
			    	<input type="hidden" name="hizmet" value="{{ hizmetId }}">
			      	<div class="row mb-3">
				        <div class="col-md-3 col-12">
				        	{{ partial('includes/placeholderimage', ['image': hizmet.image.medium, 'title': hizmet.title]) }}

							<div class="input-group mb-3">
								<div class="custom-file">
									<input type="file" class="custom-file-input" name="image">
									<label class="custom-file-label rounded-0 small">Dosya Seç</label>
								</div>
							</div>							
						</div>

				        <div class="col-md-9 col-12">
				            <div class="form-group">
							 	<label class="form-label font-weight-bold">Başlık</label>
								<input class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="title" value="{{ hizmet.title|escape }}">
							</div>			          
							<div class="form-group">
								<label class="form-label font-weight-bold">Açıklama</label>
								<input class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="description" value="{{ hizmet.description|escape }}">
							</div>

					        <div class="form-group">
					        	<div class="custom-control custom-radio custom-control-inline">
								  <input type="radio" value="on" id="hizmetAktif{{ hizmetId }}" name="aktifpasif" {% if hizmet.active %}checked{% endif %} class="custom-control-input">
								  <label class="custom-control-label" for="hizmetAktif{{ hizmetId }}">Aktif</label>
								</div>
								<div class="custom-control custom-radio custom-control-inline">
								  <input type="radio" value="off" id="hizmetPasif{{ hizmetId }}" name="aktifpasif" {% if !hizmet.active %}checked{% endif %} class="custom-control-input">
								  <label class="custom-control-label" for="hizmetPasif{{ hizmetId }}">Pasif</label>
								</div>
					        </div>

							<div class="form-group text-md-right">
								<button type="submit" name="update" class="btn btn-success rounded-0 pl-5 pr-5 mb-md-0 ml-3 mb-3 float-right">Kaydet</button>
								<button type="submit" name="delete" class="btn btn-danger rounded-0 pl-5 pr-5 mb-md-0 mb-3">Sil</button>
							</div>
				        </div>
			      	</div>
			    </form>
			{% endfor %}

	  	</div>
	</div>
</div>	
