{{ partial('helpers/onecikangorsel') }}

<div class="col-md-12">
	<div class="card mt-5 rounded-0">

	  	<div class="card-header">
	  		<form method="POST" action="{{ site.admin.url }}referanslar/referanslar">
		    	<input type="hidden" name="referans" value="1">
		  		<button type="submit" name="add" class="btn btn-primary float-right btn-sm rounded-0 pl-5 pr-5 mb-md-0 mb-3">Yeni Ekle</button>
	  		</form>
	    	<h4 class="card-title mb-0">Referanslar Alanı</h4>
	  	</div>

	  	<div class="card-body">

			{% for referansId, referans in page.referanslar %}
			    <form method="POST" action="{{ site.admin.url }}referanslar/referanslar" enctype="multipart/form-data">
			    	<input type="hidden" name="referans" value="{{ referansId }}">
			      	<div class="row mb-3">
				        <div class="col-md-3 col-12">
				        	{{ partial('includes/placeholderimage', ['image': referans.image.small, 'title': referans.title]) }}

							<div class="input-group mb-3">
								<div class="custom-file">
									<input type="file" class="custom-file-input" name="image">
									<label class="custom-file-label rounded-0 small">Dosya Seç</label>
								</div>
							</div>							
						</div>

				        <div class="col-md-9 col-12">
				            <div class="form-group">
							 	<label class="form-label font-weight-bold">Başlık</label>
								<input class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="title" value="{{ referans.title|escape }}">
							</div>

					        <div class="form-group">
					        	<div class="custom-control custom-radio custom-control-inline">
								  <input type="radio" value="on" id="referansAktif{{ referansId }}" name="aktifpasif" {% if referans.active %}checked{% endif %} class="custom-control-input">
								  <label class="custom-control-label" for="referansAktif{{ referansId }}">Aktif</label>
								</div>
								<div class="custom-control custom-radio custom-control-inline">
								  <input type="radio" value="off" id="referansPasif{{ referansId }}" name="aktifpasif" {% if !referans.active %}checked{% endif %} class="custom-control-input">
								  <label class="custom-control-label" for="referansPasif{{ referansId }}">Pasif</label>
								</div>
					        </div>

							<div class="form-group text-md-right">
								<button type="submit" name="update" class="btn btn-success rounded-0 pl-5 pr-5 mb-md-0 ml-3 mb-3 float-right">Kaydet</button>
								<button type="submit" name="delete" class="btn btn-danger rounded-0 pl-5 pr-5 mb-md-0 mb-3">Sil</button>
							</div>
				        </div>
			      	</div>
			    </form>
			{% endfor %}

	  	</div>
	</div>
</div>
