<div class="col-md-12 mt-4">
	<form method="POST" action="{{ site.admin.url }}urunler/save" enctype="multipart/form-data">
		<input type="hidden" name="productId" value="{{ post.id }}">
		<div class="row">
			<div class="col-md-9">
				<div class="row">
					<div class="col-md-12">
						<label class="font-weight-bold">Ürün Adı</label>
						<input type="text" class="form-control rounded-0" name="name" value="{{ post.name|escape }}">
					</div>
					<div class="col-md-12 mt-4">
						<label class="font-weight-bold">İçerik</label>
						<textarea class="form-control rounded-0" rows="12" name="content" id="editor">{{ post.content }}</textarea>
					</div>
				</div>
			</div>

			<div class="col-md-3">
				<div class="row">
					<div class="col-md-12 mt-4">
				    	{{ partial('includes/placeholderimage', ['image': post.image, 'title': post.name]) }}
						<div class="input-group">
							<div class="custom-file">
								<input type="file" class="custom-file-input" name="image">
								<label class="custom-file-label rounded-0 small">Dosya Seç</label>
							</div>
						</div>
					</div>

					{% if post.id > 0 %}
						<div class="col-md-6">
							<a href="{{ site.admin.url }}urunler/delete/{{ post.id }}" class="btn btn-block btn-danger rounded-0 mt-2">Kaldır</a>
						</div>
						<div class="col-md-6">
							<button class="btn btn-block btn-success rounded-0 mt-2">Kaydet</button>
						</div>
					{% else %}
						<div class="col-md-12">
							<button class="btn btn-block btn-success rounded-0 mt-2">Ekle</button>
						</div>				
					{% endif %}
				</div>
			</div>

		</div>
	</form>
</div>

<script type="text/javascript">
CKEDITOR.config.height = 450;
CKEDITOR.config.allowedContent = true;
CKEDITOR.config.removeFormatAttributes = '';
CKEDITOR.config.extraPlugins = 'wysiwygarea, uploadimage, iframe';
CKEDITOR.replace('editor', { 
    filebrowserUploadUrl: '{{ site.admin.url }}fileUpload/upload/{{ post.id }}'
});
</script>