{{ partial('includes/thumbnail', ['thumbnail': iletisim.thumbnail]) }}

<section class="gallery mb-5">
  <div class="container">

	<div class="row">

		{% if site.general.contact.map.active %}
		  	<div class="col-md-12">
				<h3 class="box-title text-left font-weight-bold text-uppercase mb-4">İletişim</h3>
		  	</div>
			<div class="col-md-12 mb-5">
				<div class="embed-responsive embed-responsive-21by9">
				  <iframe loading="lazy" class="embed-responsive-item maps" src="{{ site.general.contact.map.url|escape }}"></iframe>
				</div>
			</div>
		{% endif %}

	  	<div class="col-md-6 mb-3">
	        <h4 class="box-title text-left font-weight-bold mb-4">İletişim Bilgileri</h4>

	        <div class="address">
	        	{% if site.general.contact.address %}
	          		<p><strong>Adres:</strong> {{ site.general.contact.address|escape }}</p>
	        	{% endif %}

	        	{% if site.general.contact.email %}
	          		<p><strong>Email:</strong> {{ site.general.contact.email|escape }}</p>
	        	{% endif %}

	        	{% if site.general.contact.phone %}
	          		<p><strong>Telefon:</strong> {{ site.general.contact.phone|escape }}</p>
	        	{% endif %}

	        	{% if site.general.contact.gsm %}
	          		<p><strong>GSM:</strong> {{ site.general.contact.gsm|escape }}</p>
	        	{% endif %}   

	        	{% if site.general.contact.whatsapp %}
	          		<p>
	          			<strong>Whatsapp:</strong> 
	          			<a href="https://api.whatsapp.com/send?phone={{ site.general.contact.whatsapp|escape }}&text=Merhaba%20size%20bir%20sorum%20var%2C%20yard%C4%B1mc%C4%B1%20olabilir%20misiniz%3F" class="text-dark" target="_blank">
	          				{{ site.general.contact.whatsapp|escape }}
	          			</a>
	          	</p>
	        	{% endif %}    	
			  	
	      </div>


	      <h4 class="box-title text-left font-weight-bold mt-5 mb-4">Sosyal Medya</h4>

	        <div class="social-media mb-5">

				{% if site.general.social.facebook %}
					<a target="_blank" href="{{ site.general.social.facebook|escape }}">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448 80v352c0 26.5-21.5 48-48 48h-85.3V302.8h60.6l8.7-67.6h-69.3V192c0-19.6 5.4-32.9 33.5-32.9H384V98.7c-6.2-.8-27.4-2.7-52.2-2.7-51.6 0-87 31.5-87 89.4v49.9H184v67.6h60.9V480H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48z" class="svg-master"/></svg>
					</a>
				{% endif %}

				{% if site.general.social.twitter %}
					<a target="_blank" href="{{ site.general.social.twitter|escape }}">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm-48.9 158.8c.2 2.8.2 5.7.2 8.5 0 86.7-66 186.6-186.6 186.6-37.2 0-71.7-10.8-100.7-29.4 5.3.6 10.4.8 15.8.8 30.7 0 58.9-10.4 81.4-28-28.8-.6-53-19.5-61.3-45.5 10.1 1.5 19.2 1.5 29.6-1.2-30-6.1-52.5-32.5-52.5-64.4v-.8c8.7 4.9 18.9 7.9 29.6 8.3a65.447 65.447 0 0 1-29.2-54.6c0-12.2 3.2-23.4 8.9-33.1 32.3 39.8 80.8 65.8 135.2 68.6-9.3-44.5 24-80.6 64-80.6 18.9 0 35.9 7.9 47.9 20.7 14.8-2.8 29-8.3 41.6-15.8-4.9 15.2-15.2 28-28.8 36.1 13.2-1.4 26-5.1 37.8-10.2-8.9 13.1-20.1 24.7-32.9 34z" class="svg-master"/></svg>
					</a>
				{% endif %}

				{% if site.general.social.youtube %}
					<a target="_blank" href="{{ site.general.social.youtube|escape }}">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M186.8 202.1l95.2 54.1-95.2 54.1V202.1zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-42 176.3s0-59.6-7.6-88.2c-4.2-15.8-16.5-28.2-32.2-32.4C337.9 128 224 128 224 128s-113.9 0-142.2 7.7c-15.7 4.2-28 16.6-32.2 32.4-7.6 28.5-7.6 88.2-7.6 88.2s0 59.6 7.6 88.2c4.2 15.8 16.5 27.7 32.2 31.9C110.1 384 224 384 224 384s113.9 0 142.2-7.7c15.7-4.2 28-16.1 32.2-31.9 7.6-28.5 7.6-88.1 7.6-88.1z" class="svg-master"/></svg>
					</a>
				{% endif %}

				{% if site.general.social.instagram %}
					<a target="_blank" href="{{ site.general.social.instagram|escape }}">
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z" class="svg-master"/></svg>
					</a>
				{% endif %}  	
			  	
	       </div>

	    </div>

		<div class="col-md-6 mb-3">
	        <h4 class="box-title text-left font-weight-bold mb-4">İletişim Formu</h4>

	        <div class="form">
	        	
				<form method="POST" action="{{ site.url }}iletisim/sendemail">

					{{ partial('helpers/notification/errors') }}
					{{ partial('helpers/notification/success') }}

				    <div class="form-group">
					    <input name="fullName" type="text" class="form-control rounded-0" placeholder="Ad Soyad">
					 </div>

				    <div class="form-group">
				      	<input name="email" type="email" class="form-control rounded-0" placeholder="E-Mail">
				    </div>

				    <div class="form-group">
				      	<textarea name="message" class="form-control rounded-0" placeholder="Mesaj" rows="5"></textarea>
				    </div>

				  	<button type="submit" class="btn btn-block btn-lg btn-master text-white rounded-0">Gönder</button>
				</form>

	       </div>
	    </div>

	</div>
  </div>
</section>
