<?php

use Phalcon\Di\FactoryDefault;

ini_set('display_errors', 0);
error_reporting(0);

/**
 *
 * Projenin Ana Klasörü
 *
 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
 *
 */
define('BASE_PATH', dirname(__DIR__));

/**
 *
 * Projenin app klasörü
 *
 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
 *
 */
define('APP_PATH', BASE_PATH . '/app');

/**
 *
 * Projenin Error klasörü
 *
 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
 *
 */
define('ERROR_PATH', APP_PATH . '/error/');

try {

    /**
     * The FactoryDefault Dependency Injector automatically registers
     * the services that provide a full stack framework.
     */
    if (class_exists('Phalcon\Di\FactoryDefault')) 
    {

        $di = new FactoryDefault();

        /**
         *  Kurulum kontrollerini çağırma
         */
        include APP_PATH . '/config/install.php';

        /**
         * CMS Sabitlerini çağırma
         */
        include APP_PATH . '/config/cms.php';

        /**
         * Handle routes
         */
        include APP_PATH . '/config/router.php';

        /**
         * Read services
         */
        include APP_PATH . '/config/services.php';

        /**
         * Get config service for use in inline setup below
         */
        $config = $di->getConfig();

        /**
         * Include Autoloader
         */
        include APP_PATH . '/config/loader.php';

        /**
         * Handle the request
         */
        $application = new \Phalcon\Mvc\Application($di);

    //    echo str_replace(["\n","\r","\t"], '', $application->handle()->getContent());
        echo $application->handle()->getContent(); 
    }
    else
    {
        include ERROR_PATH . '666.html';
    }

} catch (Phalcon\Mvc\Dispatcher\Exception $e) {
    include ERROR_PATH . '404.html';
}catch (\Exception $e) {
    include ERROR_PATH . '503.html';
}
