<?php 

Class Utility
{

	/**
	 *
	 * Json çıktıyı basar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $data
	 *
	 */
	public function sendOutputJson($data)
	{
		header('Content-Type: application/json');
		echo json_encode($data);
		exit;
	}

	/**
	 *
	 * Yönlendirme yapar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $url
	 *
	 */
	public function redirect($url)
	{
		header('Location: '. $url);
		exit;
	}

	/**
	 *
	 * Website linkini döner.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @return string 
	 *
	 */
	public function getWebsiteLink()
	{
		$http = 'https';
		if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] != 'on') {
			$http = 'http';
		}

		$pageName = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME'] : $_SERVER['PHP_SELF'];

		$link = sprintf('%s://%s%s', $http, $_SERVER['HTTP_HOST'], str_replace('index.php', '', $pageName));
		return str_replace(array('public/install/install.php', 'install/install.php'), '', $link);
	}

	/**
	 *
	 * Kurulumu tamamlar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $path
	 * @return boolean 
	 *
	 */
	public function installFinished($filePath, $newName)
	{

		$this->installSitemap($this->getWebsiteLink());
		$this->installRobotTxt($this->getWebsiteLink());

		$newInstallName = PUBLIC_PATH . 'installed_' . $newName;

		rename($filePath, $newInstallName);
		$this->removeFolder($newInstallName);
		return false;
	}

	/**
	 *
	 * Sitemap kurulumunu tamamlar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $url
	 *
	 */
	public function installSitemap($url)
	{
		$sitemapContent = file_get_contents(PUBLIC_PATH . 'sitemap.xml');
		$sitemapContent = str_replace('{website}', $url, $sitemapContent);
		$sitemapContent = str_replace('{date}', date('c'), $sitemapContent);

		$handle = fopen(PUBLIC_PATH . 'sitemap.xml', 'w+');
		fwrite($handle, $sitemapContent);
		fclose($handle);
	}

	/**
	 *
	 * RobotTXT kurulumunu tamamlar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $url
	 *
	 */
	public function installRobotTxt($url)
	{
		$robotContent = file_get_contents(PUBLIC_PATH . 'robots.txt');
		$robotContent = str_replace('{website}', $url, $robotContent);

		$handle = fopen(PUBLIC_PATH . 'robots.txt', 'w+');
		fwrite($handle, $robotContent);
		fclose($handle);
	}

	/**
	 *
	 * Dosya kaldırır
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $path
	 * @return boolean 
	 *
	 */
	public function removeFile($filePath)
	{
		if(file_exists($filePath)){
			return unlink($filePath);		
		}

		return false;
	}

	/**
	 *
	 * Klasörü kaldırır
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $path
	 *
	 */
	public function removeFolder($folderPath)
	{

		foreach (scandir($folderPath) as $filePath) 
		{

			if($filePath == "." || $filePath == ".."){
				continue;
			}

			$fullPath = $folderPath . DIRECTORY_SEPARATOR . $filePath;
			if (is_dir($fullPath)) {
				$this->removeFolder($fullPath);
			}else{
				$this->removeFile($fullPath);
			}

		}

		if (file_exists($folderPath)) {
			rmdir($folderPath);
		}

	}

}

$utility = new Utility();